DIM mem(1 TO 8192) AS STRING * 1
DIM lng AS LONG

OPEN "COM2:9600,N,8,2,BIN,CD0,CS0,DS0,OP0,RB32767,TB1" FOR RANDOM AS #1
FOR i = 1 TO 8192
  DO
  LOOP UNTIL LOC(1) > 0
  GET #1, , mem$(i)
NEXT i
CLOSE #1

OPEN "mem-oct.txt" FOR OUTPUT AS #1
FOR i = 1 TO 8192 STEP 2
  PRINT #1, OCT$(i + 57343); ": ";
  LET lng = ASC(mem$(i + 1))
  LET lng = lng * 256 + ASC(mem$(i))
  LET wordS$ = OCT$(lng)
  IF ASC(mem$(i + 1)) < 32 THEN
    LET charS$ = "."
  ELSE
    LET charS$ = mem$(i + 1)
  END IF
  IF ASC(mem$(i)) < 32 THEN
    LET charS$ = charS$ + "."
  ELSE
    LET charS$ = charS$ + mem$(i)
  END IF
  DO WHILE LEN(wordS$) < 6
    wordS$ = "0" + wordS$
  LOOP
  PRINT #1, wordS$; " : "; charS$
NEXT i
CLOSE #1

OPEN "mem-hex.txt" FOR OUTPUT AS #1
FOR i = 1 TO 8192 STEP 16
  PRINT #1, HEX$(i + 57343); ": ";
  LET charS$ = ""
  FOR j = 1 TO 16
    LET byteS$ = HEX$(ASC(mem$(i + j - 1)))
    IF ASC(mem$(i + j - 1)) < 32 THEN
      LET charS$ = charS$ + "."
    ELSE
      LET charS$ = charS$ + mem$(i + j - 1)
    END IF
    DO WHILE LEN(byteS$) < 2
      byteS$ = "0" + byteS$
    LOOP
    PRINT #1, byteS$; " ";
    IF j = 8 THEN
      PRINT #1, " ";
      LET charS$ = charS$ + "  "
    END IF
  NEXT j
  PRINT #1, ": "; charS$
NEXT i
CLOSE #1

OPEN "mem-bin.txt" FOR BINARY AS #1
FOR i = 1 TO 8192
  PUT #1, , mem$(i)
NEXT i

END

REM PPU
REM     020000  012737          MOV     #070000,@#177010
REM     020002  070000
REM     020004  177010
REM     020006  012700          MOV     #040000,R0
REM     020010  040000
REM     020012  012701          MOV     #010000,R1
REM     020014  010000
REM     020016  013702  L_1:    MOV     @#177014,R2
REM     020020  177014
REM     020022  074037          XOR     R0,@#177010
REM     020024  177010
REM     020026  010237          MOV     R2,@#177014
REM     020030  177014
REM     020032  074037          XOR     R0,@#177010
REM     020034  177010
REM     020036  005237          INC     @#177010
REM     020040  177010
REM     020042  077113          SOB     R1,L1
REM     020044  000000          HALT

REM CPU
REM     001000  012700          MOV     #060000,R0
REM     001002  060000
REM     001004  012701          MOV     #020000,R1
REM     001006  020000
REM     001010  105737  L_1:    TSTB    @#176574
REM     001012  176574
REM     001014  100375          BPL     L3
REM     001016  112037          MOVB    (R0)+,@#176576
REM     001020  176576
REM     001022  077106          SOB     R1,L_1
REM     001024  000000          HALT

